(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      3352,        113]*)
(*NotebookOutlinePosition[      3994,        135]*)
(*  CellTagsIndexPosition[      3950,        131]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[
    \(f[x_] := Cos[x]\ Sin[x]\)], "Input"],

Cell[BoxData[
    \(\(Table[
        taylor[k, x_] = Normal[Series[f[x], {x, 0, k}]], {k, 1, 30, 
          2}];\)\)], "Input"],

Cell[BoxData[
    \(taylor[19, x]\)], "Input"],

Cell[BoxData[
    \(grafico[a_, b_] := 
      Do[Plot[{taylor[k, x], f[x]}, {x, a, b}, PlotRange \[Rule] {\(-2\), 2}, 
          PlotStyle \[Rule] {RGBColor[1, 0, 0], RGBColor[0, 0, 1]}], {k, 1, 
          30, 2}]\)], "Input"],

Cell[BoxData[
    \(grafico[\(-5\), 5]\)], "Input"],

Cell[BoxData[
    \(Clear["\<Global`*\>"]\)], "Input"],

Cell[BoxData[
    \(f[x_, y_] := 
      5184\ x\ y - 8640\ \(x\^3\) y - 8640  x\ y\^3 + 
        14400  x\^3\ y\^3\)], "Input"],

Cell[BoxData[
    \(gradf[x_, y_] = {D[f[x, y], x], D[f[x, y], y]}\)], "Input"],

Cell[BoxData[
    \(pcrit = Solve[gradf[x, y] \[Equal] {0, 0}, {x, y}]\)], "Input"],

Cell[BoxData[
    \(hessf[x_, 
        y_] = {{D[f[x, y], x, x], D[f[x, y], x, y]}, {D[f[x, y], x, y], 
          D[f[x, y], y, y]}}\)], "Input"],

Cell[BoxData[
    \(Table[
      Eigenvalues[hessf[x, y] /. pcrit[\([k]\)]], {k, 
        Length[pcrit]}]\)], "Input"],

Cell[BoxData[
    \(Plot3D[f[x, y], {x, \(-1\), 1}, {y, \(-1\), 1}, 
      PlotPoints \[Rule] 40]\)], "Input"],

Cell[BoxData[
    \(ContourPlot[f[x, y], {x, \(-1\), 1}, {y, \(-1\), 1}, 
      PlotPoints \[Rule] 40]\)], "Input"],

Cell[BoxData[
    \(Clear["\<Global`*\>"]\)], "Input"],

Cell[BoxData[
    \(f[x_, y_] = \((x^2 + y^2)\)/Sqrt[1 + x^2 + y^2]\)], "Input"],

Cell[BoxData[
    \(Integrate[
      Simplify[Integrate[f[x, y], {y, 0, Sqrt[1 - x^2]}]], {x, \(-1\), 
        1}]\)], "Input"]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 800}, {0, 527}},
WindowSize->{499, 369},
WindowMargins->{{0, Automatic}, {Automatic, 0}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1705, 50, 56, 1, 30, "Input"],
Cell[1764, 53, 127, 3, 50, "Input"],
Cell[1894, 58, 46, 1, 30, "Input"],
Cell[1943, 61, 226, 4, 90, "Input"],
Cell[2172, 67, 51, 1, 30, "Input"],
Cell[2226, 70, 54, 1, 30, "Input"],
Cell[2283, 73, 127, 3, 30, "Input"],
Cell[2413, 78, 79, 1, 30, "Input"],
Cell[2495, 81, 83, 1, 30, "Input"],
Cell[2581, 84, 145, 3, 50, "Input"],
Cell[2729, 89, 118, 3, 50, "Input"],
Cell[2850, 94, 110, 2, 30, "Input"],
Cell[2963, 98, 115, 2, 30, "Input"],
Cell[3081, 102, 54, 1, 30, "Input"],
Cell[3138, 105, 80, 1, 30, "Input"],
Cell[3221, 108, 127, 3, 50, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

